	subroutine compr(n,nlag,k,x,in,r,rt)
c	Subroutine to compute R_{i,j} at lags 1,...,nlag
	parameter (maxn=500, maxk=5, maxp=10,maxlag=10)
  	implicit double precision (a-h,p-z)
	double precision x(maxn,maxk),r(maxlag,maxk,maxk),sigx(maxk)
	double precision sum1(maxk),xt(maxn),yt(maxn)
	double precision rt(maxlag,maxk,maxk)
c	  Compute mean and standard deviation of each series
	sum1=0.0d0
	sigx=0.0d0
	do i=1,k
	   do j=1,n
	     sum1(i)=sum1(i)+x(j,i)
	     sigx(i)=sigx(i)+x(j,i)**2.
	   enddo
	enddo
	do i=1,k
	   sum1(i)=sum1(i)/dble(n)
	   sigx(i)=((sigx(i)-dble(n)*sum1(i)**2.d0)/dble(n-1))**.5d0
	enddo
c
	do i=1,nlag
	  do j=1,k
	    do l=1,k
	      do m=1,n-i
	        xt(m)=(x(m+i,j)-sum1(j))/sigx(j)
	        yt(m)=(x(m,l)-sum1(l))/sigx(l)
	      enddo
	     call hbivar2(in,n-i,xt,yt,deltai,rho)
	     r(i,j,l)= deltai
	     rt(i,j,l)=rho
	     if (deltai.lt.0.0d0) deltai=0.0d0
	     r(i,j,l)=(1.0-dexp(-2.0*deltai))**.5 
	    enddo
	  enddo
	enddo
c
	return
	end
